/**
 * 
 */
package com.ejie.ab18a.utils;

import java.io.ByteArrayInputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.xmlbeans.ServicioObtencionPerfilesUsuarios;
import com.ejie.xmlbeans.TipoEntidadImpulsora;
import com.ejie.xmlbeans.TipoOperacion;
import com.ejie.xmlbeans.TipoPoder;

/**
 * @author XXXX
 * 
 */
public class Ab18aConvertirJaxb {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aConvertirJaxb.class);

	/**
	 * Xml to perfil.
	 * 
	 * @param xml
	 *            the xml
	 * @return the tipo perfil
	 */
	public ServicioObtencionPerfilesUsuarios xmlToPerfiles(String xml) {

		ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
		ServicioObtencionPerfilesUsuarios perfil = null;
		try {

			JAXBContext jc = JAXBContext.newInstance("com.ejie.xmlbeans");
			Unmarshaller u = jc.createUnmarshaller();
			// SchemaFactory
			// schemaFactory =
			// SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
			// Schema schema =
			// schemaFactory.newSchema(new File(
			// Y46jPropertiesManager.getProperty("xsd.consultaPerfil")));
			// u.setSchema(schema);
			Object jaxbObject = u.unmarshal(input);
			perfil = (ServicioObtencionPerfilesUsuarios) jaxbObject;

		} catch (Exception e) {
			Ab18aConvertirJaxb.logger.error("Entramos en xmlToPerfiles...xml: '" + xml + "'");
			Ab18aConvertirJaxb.logger.error("Se ha producido un error en XmlToPerfil: ", e);
		}
		return perfil;
	}

	/**
	 * Xml to poder.
	 * 
	 * @param xml
	 *            the xml
	 * @return the tipo poder
	 */
	public TipoPoder xmlToPoder(String xml) {
		ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
		TipoPoder poder = null;
		try {
			JAXBContext jc = JAXBContext.newInstance("com.ejie.xmlbeans");
			Unmarshaller u = jc.createUnmarshaller();
			JAXBElement<?> jaxbObject = (JAXBElement<?>) u.unmarshal(input);
			poder = (TipoPoder) jaxbObject.getValue();

		} catch (Exception e) {
			Ab18aConvertirJaxb.logger.error("Fin de XmlToPoder...xml: '" + xml + "'");
			Ab18aConvertirJaxb.logger.error("Se ha producido un error en XmlToPoder: ", e);
		}

		return poder;
	}

	/**
	 * Xml to entidad impulsora.
	 * 
	 * @param xml
	 *            the xml
	 * @return the tipo entidad impulsora
	 */
	public TipoEntidadImpulsora xmlToEntidadImpulsora(String xml) {
		Ab18aConvertirJaxb.logger.debug("Entramos en XmlToEntidadImpulsora...xml: '" + xml + "'");

		ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
		TipoEntidadImpulsora entidad = null;
		try {
			JAXBContext jc = JAXBContext.newInstance("com.ejie.xmlbeans");
			Unmarshaller u = jc.createUnmarshaller();
			JAXBElement<?> jaxbObject = (JAXBElement<?>) u.unmarshal(input);
			entidad = (TipoEntidadImpulsora) jaxbObject.getValue();

		} catch (Exception e) {
			Ab18aConvertirJaxb.logger.error("YFin de XmlToEntidadImpulsora...xml: '" + xml + "'");
			Ab18aConvertirJaxb.logger.error("Se ha producido un error en XmlToEntidadImpulsora: ", e);
		}

		return entidad;
	}

	/**
	 * Xml to tipo operacion.
	 * 
	 * @param xml
	 *            the xml
	 * @return the tipo operacion
	 */
	public TipoOperacion xmlToTipoOperacion(String xml) {
		Ab18aConvertirJaxb.logger.debug("Entramos en XmlToTipoOperacion...xml: '" + xml + "'");

		ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
		TipoOperacion operacion = null;
		try {
			JAXBContext jc = JAXBContext.newInstance("com.ejie.xmlbeans");
			Unmarshaller u = jc.createUnmarshaller();
			JAXBElement<?> jaxbObject = (JAXBElement<?>) u.unmarshal(input);
			operacion = (TipoOperacion) jaxbObject.getValue();

		} catch (Exception e) {
			Ab18aConvertirJaxb.logger.warn("Ab18aConvertirJaxb: Se ha producido un error en XmlToTipoOperacion: " + e.getMessage());
		}
		Ab18aConvertirJaxb.logger.debug("Ab18aConvertirJaxb: Fin de XmlToTipoOperacion...xml: '" + xml + "'");
		return operacion;
	}
}
